/******************************************************/
/* Examples Program For "ET-BASE dsPIC30F4011"  Board */
/* Hardware    : ET-BASE dsPIC30F4011                 */
/* Target MCU  : dsPIC30F4011                         */
/*       	   : X-TAL : 7.3728 MHz                   */
/*             : Run 117.9648MHz                      */
/*             : Selec OSC Mode = XT w/PLL 16x        */
/* Compiler    : MPLAB v8.40 + C30 v3.20B      	      */
/* Last Update : 12/October/2009                      */
/******************************************************/
/* Function    : Example Use I2C Connect PCF8574      */
/*             : LED Moving on Output of PCF8574      */	
/******************************************************/
/* Used ET-MINI I/O PCF8574A Module Interface         */
/* SDA = RF2(I2C-SDA)                                 */
/* SCL = RF3(I2C-SCL)                                 */
/* Setup PCF8574A Address = "000"                     */
/******************************************************/

#include <p30f4011.h>                                		// dsPIC30F4011 MPU Register
#include "i2c.h"											// Used I2C Function Library

/* Setup Configuration For ET-BASE dsPIC30F4011 */
_FOSC(CSW_FSCM_OFF & XT_PLL16);								// Disable Clock Switching,Enable Fail-Salf Clock
                                                            // Clock Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_OFF & PWRT_64 & MCLR_EN);					    // Disable Brown-Out ,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End Configuration For ET-BASE dsPIC30F4011 */

/* pototype  section */
void delay_led(unsigned long int);							// Delay Time Function
void init_i2c(void);										// Initial I2C For Interface PCF8574A

int main(void)
{  
  unsigned char LED; 										// LED Buffer Display

  init_i2c();												// Initial I2C Function
   
  // Start Test Output I2C(PCF8574A) //
  while(1)													// Loop Continue
  {
    for (LED = 0x01; LED < 0x80; LED <<= 1)					// Shift Left LED(Right <- Left)
    { 
      StartI2C();											// Send Start Condition
	  while(I2CCONbits.SEN);								// Wait Start Complete
      
	  MasterWriteI2C(0x70);									// Write PCF8574A ID Code (0111000+W)
	  while(I2CSTATbits.TBF);								// Wait Write Address Complete
	  while(I2CSTATbits.ACKSTAT);							// Wait Acknowledge Complete
      IdleI2C();											// Wait Status Clear     
     
      MasterWriteI2C(0xFF-LED);								// Write Output Data to PCF8574A(Toggle Logic)
      while(I2CSTATbits.TBF);								// Wait Write Data Complete
	  while(I2CSTATbits.ACKSTAT);							// Wait Acknowledge Complete
      IdleI2C();											// Wait Status Clear  

	  StopI2C();											// Send Stop Condition
      while(I2CCONbits.PEN);								// Wait Stop Complete	
      
      delay_led(1500000);	    							// Display Delay	    			
    }								 

    for (LED = 0x80; LED > 0x01; LED >>= 1)					// Shift Right LED(Right -> Left)
    { 
      StartI2C();											// Send Start Condition
	  while(I2CCONbits.SEN);								// Wait Start Complete
      
	  MasterWriteI2C(0x70);									// Write PCF8574A ID Code (0111000+W)
	  while(I2CSTATbits.TBF);								// Wait Write Address Complete
	  while(I2CSTATbits.ACKSTAT);							// Wait Acknowledge Complete
      IdleI2C();											// Wait Status Clear       
     
      MasterWriteI2C(0xFF-LED);								// Write Output Data to PCF8574A(Toggle Logic)
      while(I2CSTATbits.TBF);								// Wait Write Data Complete
      while(I2CSTATbits.ACKSTAT);							// Wait Acknowledge Complete
      IdleI2C();											// Wait Status Clear  

	  StopI2C();											// Send Stop Condition
      while(I2CCONbits.PEN);								// Wait Stop Complete	
      
      delay_led(1500000);	    							// Display Delay	    			
    }		    
  }   
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay_led(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}

/*************************************/
/* Initial dsPIC30F4011 I2C Function */
/* For Interface PCF8574A (I2C I/O)  */
/*************************************/
void init_i2c(void)
{  
  CloseI2C();												// Close I2C Before New Config  

  // Open I2C Function For Interface PCF8574A
  OpenI2C(I2C_ON &											// Enable I2C Function
		  I2C_IDLE_STOP &									// Disable I2C in IDLE Mode
		  I2C_CLK_HLD &										// I2C Clock Hold
		  I2C_IPMI_DIS &     								// Disable I2C IPMI Mode Control
		  I2C_7BIT_ADD &									// I2C Device Address = 7 Bit
		  I2C_SLW_DIS &										// Disable I2C Slew Rate Control
		  I2C_SM_DIS &										// Disable I2C SMBUS Mode
		  I2C_GCALL_DIS &									// Disable I2C General Call(Slave) 
          I2C_STR_DIS &										// Disable SCL Clock Stretch
          I2C_ACK &											// ACK Cycle = ACK
	      I2C_ACK_DIS &										// Disable I2C Acknowledge
		  I2C_RCV_DIS &										// Disable I2C Receive
		  I2C_STOP_DIS &									// Disable I2C Stop		
		  I2C_RESTART_DIS &									// Disable I2C Restart
		  I2C_START_DIS,									// Disable I2C Start		

          // ET-BASE dsPIC30F4011 Hardware Board
		  // XTAL = 7.3728MHz
  		  // Fosc = 7.3728 MHz x 16 = 117.9648 MHz
  		  // Fcy(I2C) = Fosc / 4 
  		  //           = 117.9648 / 4 = 29.4912 MHz          
  		  // I2CBRG = [(Fcy/Fscl)-(Fcy/1,111,111)]-1
  		  //       = [(29.4912 MHz / 100KHz)-(29.4912MHz / 1,111,111)] - 1
          //       = [(294.912)-(26.542)]-1
          //       = 268.37 - 1
  		  //       = 267 = 10BH
		  267);												// I2C Baudrate(Approx. = 100 KHz)

  // Initial I2C Interrupt Control
  ConfigIntI2C(MI2C_INT_OFF &								// Disabe Master I2C Interrupt
               SI2C_INT_OFF &								// Disabe Slave I2C Interrupt
               MI2C_INT_PRI_7 &								// Set Priority Interrupt of Master = 7 
			   SI2C_INT_PRI_7 );							// Set Priority Interrupt of Slave = 7                 
}
